<?php
/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package News Brick Kit
 */

get_header();
?>
	<div class="theme-container">
		<div class="nekit-container">
			<div class="row">
				<main id="primary" class="site-main">
					<div class="primary-content">
						<div class="nekit-news-list-wrap">
							<?php
								if ( have_posts() ) :
							?>
									<header class="page-header">
										<h1 class="page-title">
											<?php
											/* translators: %s: search query. */
											printf( esc_html__( 'Search Results for: %s', 'news-brick-kit' ), '<span>' . get_search_query() . '</span>' );
											?>
										</h1>
									</header><!-- .page-header -->
									<div class="nekit-news-list-box-wrap">
										<?php
										/* Start the Loop */
										while ( have_posts() ) :
											the_post();

											/**
											 * Run the loop for the search to output the results.
											 * If you want to overload this in a child theme then include a file
											 * called content-search.php and that will be used instead.
											 */
											get_template_part( 'template-parts/content', 'search' );

										endwhile;

									else :

										get_template_part( 'template-parts/content', 'none' );

									endif;
								?>
							</div>
							<?php
							the_posts_navigation();
							?>
						</div>
					</div>
				</main><!-- #main -->
				<div class="secondary-sidebar"><?php get_sidebar(); ?></div>
			</div>
		</div>
	</div>

<?php
get_footer();